/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.standard.v2_1.parts;

import com.roguewave.chart.core.v2_1.graphics.Point3D;
import com.roguewave.chart.core.v2_1.graphics.Polygon3D;
import com.roguewave.chart.core.v2_1.graphics.Transform3D;
import java.awt.Color;

public class LineSegment {
    private Polygon3D[] faces_;
    private Polygon3D[] frontFace_;

    public LineSegment(double leftValue, double rightValue, double thickness, double depth, Transform3D transform, Color color) {
        this(leftValue, rightValue, thickness, depth, transform, color, true);
    }

    public LineSegment(double leftValue, double rightValue, double thickness, double depth, Transform3D transform, Color color, boolean outline) {
        double halfthick = thickness / 2.0;
        double zOff = (1.0 - depth) / 2.0;
        Point3D left1raw = new Point3D(0.0, leftValue + halfthick, zOff);
        Point3D left2raw = new Point3D(0.0, leftValue - halfthick, zOff);
        Point3D right1raw = new Point3D(1.0, rightValue + halfthick, zOff);
        Point3D right2raw = new Point3D(1.0, rightValue - halfthick, zOff);
        Point3D p1 = transform.transform(left1raw);
        Point3D p2 = transform.transform(right1raw);
        Point3D p3 = transform.transform(right2raw);
        Point3D p4 = transform.transform(left2raw);
        Transform3D backTrans = Transform3D.translate(0.0, 0.0, depth);
        Point3D p8 = backTrans.transform(p1);
        Point3D p7 = backTrans.transform(p2);
        Point3D p6 = backTrans.transform(p3);
        Point3D p5 = backTrans.transform(p4);
        this.faces_ = new Polygon3D[6];
        this.frontFace_ = new Polygon3D[1];
        this.faces_[0] = new Polygon3D(4, color);
        this.faces_[0].addPoint(p1);
        this.faces_[0].addPoint(p2);
        this.faces_[0].addPoint(p3);
        this.faces_[0].addPoint(p4);
        this.faces_[0].setOutlines(outline);
        this.frontFace_[0] = this.faces_[0];
        this.faces_[1] = new Polygon3D(4, color);
        this.faces_[1].addPoint(p5);
        this.faces_[1].addPoint(p6);
        this.faces_[1].addPoint(p7);
        this.faces_[1].addPoint(p8);
        this.faces_[1].setOutlines(outline);
        this.faces_[2] = new Polygon3D(4, color);
        this.faces_[2].addPoint(p1);
        this.faces_[2].addPoint(p8);
        this.faces_[2].addPoint(p7);
        this.faces_[2].addPoint(p2);
        this.faces_[2].setOutlines(outline);
        this.faces_[3] = new Polygon3D(4, color);
        this.faces_[3].addPoint(p3);
        this.faces_[3].addPoint(p6);
        this.faces_[3].addPoint(p5);
        this.faces_[3].addPoint(p4);
        this.faces_[3].setOutlines(outline);
        this.faces_[4] = new Polygon3D(4, color);
        this.faces_[4].addPoint(p1);
        this.faces_[4].addPoint(p4);
        this.faces_[4].addPoint(p5);
        this.faces_[4].addPoint(p8);
        this.faces_[4].setOutlines(outline);
        this.faces_[5] = new Polygon3D(4, color);
        this.faces_[5].addPoint(p2);
        this.faces_[5].addPoint(p7);
        this.faces_[5].addPoint(p6);
        this.faces_[5].addPoint(p3);
        this.faces_[5].setOutlines(outline);
    }

    public Polygon3D[] polygons() {
        return this.faces_;
    }

    public Polygon3D[] front() {
        return this.frontFace_;
    }
}

